<?php
//pagoflow.php
include("conexioncrud.php");
require 'clienteflow/lib/FlowApi.class.php'; // Asegúrate de que la ruta sea correcta

// KEYS HOSTAL
define('API_KEY_HOSTAL', "6FD1ADFC-AFB0-42F8-B492-54D75L946918");
define('SECRET_KEY_HOSTAL', "266e6cf864ff129a1cb91e75418dea337555a490");

// KEYS VECTOR (comentar si no se usa)
// define('API_KEY_VECTOR', "1F9B067F-36BB-475D-884F-752CCEEL3C03");
// define('SECRET_KEY_VECTOR', "624a2c1e5f556f0eb9acafd757ccfeff563a1a75");

$COMMERCE_CONFIG = array(
    "APIKEY" => API_KEY_HOSTAL, // Reemplaza con tu apiKey
    "SECRETKEY" => SECRET_KEY_HOSTAL, // Reemplaza con tu secretKey
    "APIURL" => "https://www.flow.cl/api/payment/create", // URL del API de Flow (sandbox o producción)
    "BASEURL" => "https://hostalriberasdelcruces.cl/php/clienteflow" // URL base donde instalaste el cliente
);

try {
    // Verificar si id_reserva está seteado
    if (!isset($_GET['id_reserva'])) {
        throw new Exception("No se recibió el ID de la reserva.");
    }

    $id_reserva = mysqli_real_escape_string($con, $_GET['id_reserva']);
    $sql_reservas = "SELECT * FROM reservas WHERE id_reserva = '$id_reserva'";
    $query_reservas = mysqli_query($con, $sql_reservas);

    if (!$query_reservas) {
        throw new Exception("Error al realizar la consulta de reservas: " . mysqli_error($con));
    }

    $row_reserv = mysqli_fetch_assoc($query_reservas);
    if (!$row_reserv) {
        throw new Exception("No se encontró la reserva con el ID proporcionado.");
    }

    $id_habitacion = $row_reserv['id_habitacion'];    
    $n_habitacion = $row_reserv['numero'];
    $fecha_entrada = $row_reserv['fecha_entrada'];
    $fecha_salida = $row_reserv['fecha_salida'];
    $cantidad_personas = $row_reserv['cantidad_personas'];
    $nombre = $row_reserv['cliente'];
    $telefono = $row_reserv['telefono'];
    $notas = $row_reserv['notas'];
    $email = $row_reserv['correo']; // el mail
    $montoPago = str_replace('.', '', $row_reserv['total']); // es el valor total a pagar, debe ser int
    $ordenCompra = $row_reserv['orden_compra'];

    $sql_habitacion = "SELECT * FROM habitaciones WHERE id_habitacion = '$id_habitacion'";
    $query_habitacion = mysqli_query($con, $sql_habitacion);

    if (!$query_habitacion) {
        throw new Exception("Error al realizar la consulta de habitaciones: " . mysqli_error($con));
    }

    $row_habitacion = mysqli_fetch_assoc($query_habitacion);
    if (!$row_habitacion) {
        throw new Exception("No se encontró la habitación con el ID proporcionado.");
    }

    $nombre_habitacion = $row_habitacion['nombre_habitacion'];

    // Concatenar los datos
    $stringdatos = $id_habitacion || $fecha_entrada || $fecha_salida || $nombre_habitacion || $cantidad_personas || $nombre || $telefono || $notas || $email || $montoPago || $ordenCompra || $n_habitacion;
    
    // Registrar los datos concatenados
    $sql_logs = "INSERT INTO logs_registros (descripcion) VALUES ('$stringdatos')";
    if (!mysqli_query($con, $sql_logs)) {
        throw new Exception("Error al registrar los logs: " . mysqli_error($con));
    }
    
    $id_reserva_datos = mysqli_insert_id($con);
    $client2 = "flowexitoso||$id_reserva";

    // Parámetros de la orden de pago
    $params = array(
        "commerceOrder" => $ordenCompra, // Identificador único de tu orden
        "subject" => 'Pago de Reserva de Habitación', // Descripción del pago
        "currency" => "CLP", // Moneda (Pesos Chilenos)
        "amount" => $montoPago, // Monto del pago
        "email" => $email, // Email del cliente
        "paymentMethod" => 9, // Método de pago (9 para todos los métodos)
        "urlConfirmation" => "https://hostalriberasdelcruces.cl/php/confirmacion.php",
        "urlReturn" => "https://hostalriberasdelcruces.cl/php/tabla_mis_reservas.php?client=" . $client2,
    );

    // Crear instancia de FlowApi
    $flowApi = new FlowApi($COMMERCE_CONFIG);

    // Ejecutar el servicio de creación de pago
    $response = $flowApi->send("payment/create", $params, "POST");

    // Registrar la respuesta completa de la API
    $response_log = json_encode($response);
    $sql_logs = "INSERT INTO logs_registros (descripcion) VALUES ('API Response: $response_log')";
    if (!mysqli_query($con, $sql_logs)) {
        throw new Exception("Error al registrar los logs de respuesta de API: " . mysqli_error($con));
    }

    // Verificar si la respuesta contiene el token y la URL
    if (isset($response["url"]) && isset($response["token"])) {
        $redirectUrl = $response["url"] . "?token=" . $response["token"];
        header("Location: $redirectUrl");
        exit();
    } else {
        throw new Exception("Error: No se recibió el token en la respuesta de la API. Respuesta: " . $response_log);
    }

} catch (Exception $e) {
    // Manejo de errores
    registrarError($con, $e->getMessage());
    echo "Error: " . $e->getMessage();
}

function registrarError($con, $mensaje) {
    $mensaje = mysqli_real_escape_string($con, $mensaje);
    $sql_logs = "INSERT INTO logs_registros (descripcion) VALUES ('$mensaje')";
    mysqli_query($con, $sql_logs);
}

?>
<?php
// pagoflow.php
include("conexioncrud.php");
require 'clienteflow/lib/FlowApi.class.php'; // Asegúrate de que la ruta sea correcta

$apiKey = "TU_API_KEY";
$secretKey = "TU_SECRET_KEY";
$COMMERCE_CONFIG = array(
    "APIKEY" => $apiKey,
    "SECRETKEY" => $secretKey,
    "APIURL" => "https://www.flow.cl/api", // URL del API de Flow en producción
    "BASEURL" => "https://tu_dominio.com/ruta_al_cliente_flow" // URL base donde instalaste el cliente
);

try {
    $id_reserva = $_GET['id_reserva'];
    $sql_reservas = "SELECT * FROM reservas WHERE id_reserva = '$id_reserva'";
    $query_reservas = mysqli_query($con, $sql_reservas);
    $row_reserv = mysqli_fetch_assoc($query_reservas);

    // Extraer y sanitizar datos de la reserva
    $id_habitacion = $row_reserv['id_habitacion'];
    $n_habitacion = $row_reserv['numero'];
    $fecha_entrada = $row_reserv['fecha_entrada'];
    $fecha_salida = $row_reserv['fecha_salida'];
    $cantidad_personas = $row_reserv['cantidad_personas'];
    $nombre = $row_reserv['cliente'];
    $telefono = $row_reserv['telefono'];
    $notas = $row_reserv['notas'];
    $email = $row_reserv['correo'];
    $montoPago = intval(str_replace('.', '', $row_reserv['total'])); // Convertir a entero
    $ordenCompra = $row_reserv['orden_compra'];

    // Concatenar los datos para registro
    $stringdatos = implode(" || ", [
        $id_habitacion, $fecha_entrada, $fecha_salida, $n_habitacion,
        $cantidad_personas, $nombre, $telefono, $notas, $email,
        $montoPago, $ordenCompra
    ]);

    // Registrar los datos concatenados
    $sql_logs = "INSERT INTO logs_registros (descripcion) VALUES ('$stringdatos')";
    mysqli_query($con, $sql_logs);

    // Parámetros de la orden de pago
    $params = array(
        "commerceOrder" => $ordenCompra,
        "subject" => 'Pago de Reserva de Habitación',
        "currency" => "CLP",
        "amount" => $montoPago,
        "email" => $email,
        "paymentMethod" => 9, // Todos los métodos de pago
        "urlConfirmation" => "https://tu_dominio.com/confirmacion.php",
        "urlReturn" => "https://tu_dominio.com/resultado.php"
    );

    // Crear instancia de FlowApi
    $flowApi = new FlowApi();

    // Ejecutar el servicio de creación de pago
    $response = $flowApi->send("payment/create", $params, "POST");

    // Verificar si la respuesta contiene el token y la URL
    if (isset($response["url"]) && isset($response["token"])) {
        $redirectUrl = $response["url"] . "?token=" . $response["token"];
        header("Location: $redirectUrl");
        exit();
    } else {
        // Manejo de error si no se recibe el token
        $error_message = "Error: No se recibió el token en la respuesta de la API.";
        registrarError($con, $error_message);
        echo $error_message;
    }
} catch (Exception $e) {
    // Manejo de errores
    $error_message = "Error: " . $e->getCode() . " - " . $e->getMessage();
    registrarError($con, $error_message);
    echo $error_message;
}

function registrarError($con, $mensaje) {
    $mensaje = mysqli_real_escape_string($con, $mensaje);
    $sql_logs = "INSERT INTO logs_registros (descripcion) VALUES ('$mensaje')";
    mysqli_query($con, $sql_logs);
}
?>
